/*
 * Decompiled with CFR 0.152.
 */
package com.renttracker.renttrackeriknsa.Controller;

import com.renttracker.renttrackeriknsa.Entity.Bien;
import com.renttracker.renttrackeriknsa.Entity.Paiement;
import com.renttracker.renttrackeriknsa.Model.AjaxResponseBody;
import com.renttracker.renttrackeriknsa.Services.BienServices;
import com.renttracker.renttrackeriknsa.Services.PaiementServices;
import com.renttracker.renttrackeriknsa.Services.UserServices;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class PaiementController {
    @Autowired
    private PaiementServices paiementServices;
    @Autowired
    private UserServices userServices;
    @Autowired
    private BienServices bienServices;

    @RequestMapping(value={"/paiement"})
    public String list(Model model) {
        List<Paiement> paiement = this.paiementServices.findAll();
        model.addAttribute("paiements", paiement);
        return "views/paiement/list";
    }

    @RequestMapping(value={"/saisir"}, method={RequestMethod.GET})
    public String add(@Valid Paiement paiement, Model model) {
        model.addAttribute("paiement", (Object)new Paiement());
        model.addAttribute("users", this.userServices.findAll());
        return "views/paiement/add";
    }

    @RequestMapping(value={"/recupere-prix-bien"}, method={RequestMethod.POST})
    public ResponseEntity<?> getSearchResultViaAjax(@Valid @RequestBody String id, Errors errors, Model model) {
        id = id.replace("id=", "");
        Bien bien = this.bienServices.findOne(Long.parseLong(id));
        AjaxResponseBody result = new AjaxResponseBody();
        if (errors.hasErrors()) {
            result.setMsg(errors.getAllErrors().stream().map(x -> x.getDefaultMessage()).collect(Collectors.joining(",")));
            return ResponseEntity.badRequest().body((Object)result);
        }
        return ResponseEntity.ok((Object)bien.getPrix());
    }

    @RequestMapping(value={"/saisir"}, method={RequestMethod.POST})
    public String add(@Valid Paiement paiement, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return "views/paiement/add";
        }
        this.paiementServices.enregistrerPaiement(paiement);
        return "redirect:/paiement";
    }
}

