$(document).ready(function(){
      $("#bien").change(function(){

           var bien = {}
              bien["id"] = $(this).val();

          $.post("/recupere-prix-bien", {id: bien.id})
          .done(function(response, status){
                $("#prix").val(response);

                $("#prix").css("background", "#e9ecef");

                var recupere_dette = $("#prix").val() - $("#versement").val();

                $("#dette").val(recupere_dette);

                $("#versement").change(function(){

                    recupere_dette = $("#prix").val() - $("#versement").val();

                    if(recupere_dette < 0) {
                        alert("Vous ne pouvez pas de dette inférieure à 0");

                        $("#dette").css("background", "red");

                        $(".error").text("La dette ne doit pas etre nulle");

                        $("input[type=submit]").prop("disabled", true);

                    } else {
                        $("#dette").val(recupere_dette);

                        $("#dette").css("background", "#e9ecef");

                        $("input[type=submit]").prop("disabled", false);
                    }
                });
          })

          .fail(function(error, status) {
                if (error.status == 500 ){
                    $("#prix").text("");
                }
          });
      });

      $("#date").change(function(){
            CheckDate($(".periode").val());
      })

      function CheckDate(DateSaisie){

            var dateNow   =  new Date();
            var saisie = $("#date").val();

            var dateJour = new Date(dateNow.getFullYear(), dateNow.getMonth(), dateNow.getDate());

            saisie = saisie.replace(/-/g,"");

            var dateSaisie = new Date(saisie.substr(0,4), saisie.substr(4,2)-1, saisie.substr(6,2));

            if (dateSaisie > dateJour ) {
                $("#date").css("border", "2px solid red");
                $(".error").html("<div class='alert alert-danger'>Date doit être < à la date du jour !</div>");
                $("input[type=submit]").prop("disabled", false);
               	return false;
            }else {
                $("#date").css("border", "none");
                return true;
            }
      }


});
